function varargout = commblkpnseq3(block, varargin)
% COMMBLKPNSEQ2 Mask dynamic dialog function for PN Sequence Generator block.

%   Copyright 1996-2001 The MathWorks, Inc.
%   $Revision: 1.6 $  $Date: 2001/12/20 23:38:05 $

% Parse inputs
nvarargin = nargin - 1;
switch nvarargin
case 0
    action = '';
case 1
    action = varargin{1};
    Args = {};
otherwise
    action = varargin{1};
    Args = varargin{2:end};
end;

% Exit code and error message definitions
eStr.ecode = 0;
eStr.emsg  = '';

% Field data
Vals  = get_param(block, 'maskvalues');
Vis   = get_param(block, 'maskvisibilities');
En    = get_param(block, 'maskenables');

% Set Field index numbers and mask variable data
setallfieldvalues(block);

%*********************************************************************
% Function:         initialize
% Description:      Set the dialogs up based on the parameter values.
%                   MaskEnables/MaskVisibles are not save in reference 
%                   blocks.
% Inputs:           current block
% Return Values:    none
%********************************************************************
if(strcmp(action,'init'))
    cbFrameBased(block);

    % Label for reset port
    rstPortLbl = '';
    if (strcmp(Vals{idxReset},'on'))
        rstPortLbl = 'Rst';
    end

    % Set up outputs in case of early return/error
    varargout = {maskPoly, maskShift, rstPortLbl, eStr};
               
    % Check the polynomial parameter values - numeric vector only
    if ~isvector(maskPoly)
        eStr.emsg  = 'Invalid generator polynomial parameter values.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end
    if max(maskPoly)>=2
        eStr.emsg  = 'Invalid generator polynomial parameter values.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    elseif min(maskPoly)<0
        if any(maskPoly==1)
            eStr.emsg  = 'Invalid generator polynomial parameter values.';
            eStr.ecode = 1; varargout{4} = eStr; return;
        end
        tmp = zeros(1, abs(min(maskPoly))+1);
        for i = 1:length(maskPoly), tmp(abs(maskPoly(i))+1) = 1; end
        maskPoly = tmp;
    end
    % Now poly is in the binary vector representation
    if ((maskPoly(1) == 0) | (maskPoly(end) == 0)),
        eStr.emsg  = 'Invalid generator polynomial parameter values.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end
    s = length(maskPoly)-1; % degree of polynomial
    
    % Check the initial state parameter - binary, scalar or vector
    if ~( ndims(maskIni_sta)==2 & min(size(maskIni_sta))==1 )
        eStr.emsg  = 'The initial states parameter must be a scalar or a vector of length equal to the order of the generator polynomial parameter.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end
    if ~( (length(maskIni_sta) == s) | (length(maskIni_sta) == 1) )
        eStr.emsg  = 'The initial states parameter must be a scalar or a vector of length equal to the order of the generator polynomial parameter.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end
    if any(maskIni_sta~=1 & maskIni_sta~=0)
        eStr.emsg  = 'The initial states parameter values must be binary.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end

    % Check the shift (or mask) parameter - scalar, integer or binary vector
    if ~( ndims(maskShift)==2 & min(size(maskShift))==1 )
        eStr.emsg  = 'The shift (or mask) parameter must be a scalar or a vector of length equal to the order of the generator polynomial parameter.';
        eStr.ecode = 1; varargout{4} = eStr; return;
    end
    if length(maskShift)>1 % is a vector => mask
        if any(maskShift~=1 & maskShift~=0)
            eStr.emsg  = 'The mask parameter values must be binary.';
            eStr.ecode = 1; varargout{4} = eStr; return;
        end
        if (length(maskShift) ~= s)
            eStr.emsg  = 'The mask parameter must be a vector of length equal to the order of the generator polynomial parameter.';
            eStr.ecode = 1; varargout{4} = eStr; return;
        end
    else % is a scalar
        if ( ~isnumeric(maskShift) | (floor(maskShift) ~= maskShift) )
            eStr.emsg  = 'The shift parameter must be an integer scalar.';
            eStr.ecode = 1; varargout{4} = eStr; return;
        end
        % modulo the period of the sequence
        maskShift = rem(maskShift, 2^s - 1);
        if maskShift < 0
            maskShift = maskShift + 2^s - 1;
        end
    end
    
    % Reset outputs with validated parameters            
    varargout = {maskPoly, maskShift, rstPortLbl, eStr};
end;

if(strcmp(action,'cbFrameBased'))
   cbFrameBased(block);
end

%----------------------------------------------------------------------
%   Dynamic dialog specific field functions
%----------------------------------------------------------------------
%   Setup/Utility functions
%----------------------------------------------------------------------
%*********************************************************************
% Function Name:    'default'
% Description:      Set the block defaults (development use only)
% Inputs:           current block
% Return Values:    none
%********************************************************************
if(strcmp(action,'default'))

    Cb{idxPoly}          = '';
    Cb{idxIni_sta}       = '';
    Cb{idxShift}         = '';
    Cb{idxTs}            = '';
    Cb{idxFrameBased}    = 'commblkpnseq3(gcb,''cbFrameBased'');';
    Cb{idxSampPerFrame}  = '';
    Cb{idxReset}         = '';

    En{idxPoly}          = 'on';
    En{idxIni_sta}       = 'on';
    En{idxShift}         = 'on';
    En{idxTs}            = 'on';
    En{idxFrameBased}    = 'on';
    En{idxSampPerFrame}  = 'off';
    En{idxReset}         = 'on';

    Vis{idxPoly}         = 'on';
    Vis{idxIni_sta}      = 'on';
    Vis{idxShift}        = 'on';
    Vis{idxTs}           = 'on';
    Vis{idxFrameBased}   = 'on';
    Vis{idxSampPerFrame} = 'on';
    Vis{idxReset}        = 'on';

    % --- Set Callbacks, enable status and visibilities
    set_param(block,'MaskCallbacks',Cb,'MaskEnables',En,'MaskVisibilities',Vis);

    % --- Set the startup values.  '' Indicates that the default saved will be used
    Vals{idxPoly}         = '[1 1 0 0 1]';
    Vals{idxIni_sta}      = '[0 0 0 1]';
    Vals{idxShift}        = '[0 0 0 1]';
    Vals{idxTs}           = '1';
    Vals{idxFrameBased}   = 'off';
    Vals{idxSampPerFrame} = '1';
    Vals{idxReset}        = 'off';

    MN = get_param(gcb,'MaskNames');
    for n=1:length(Vals)
        if(~isempty(Vals{n}))
            set_param(block,MN{n},Vals{n});
        end;
    end;

    % --- Update the Vals field with the actual values
    Vals = get_param(block, 'maskvalues');

    % --- Set the copy function
    set_param(block,'CopyFcn','');

    % --- Ensure that the block operates correctly from a library
    set_param(block,'MaskSelfModifiable','on');
    
end;

%*********************************************************************
% Function Name:    show all
% Description:      Show all of the widgets
% Inputs:           current block
% Return Values:    none
% Notes:            This function is for development use only and allows
%                   All fields to be displayed
%********************************************************************
if(strcmp(action,'showall'))
    Vis = get_param(block, 'maskvisibilities');
    En  = get_param(block, 'maskenables');

    Cb = {};
    for n=1:length(Vis)
        Vis{n} = 'on';
        En{n} = 'on';
        Cb{n} = '';
    end;

   set_param(block,'MaskVisibilities',Vis,'MaskEnables',En,'MaskCallbacks',Cb);
end;

%----------------------------------------------------------------------
%   Subfunctions
%----------------------------------------------------------------------
%*********************************************************************
% Function Name:    'cbFrameBased'
%       Callback function for 'frameBased' parameter
%********************************************************************
function cbFrameBased(block)

Vals  = get_param(block, 'maskvalues');
En    = get_param(block, 'maskenables');
oldEnSampPerFrames   = En{6};

if(strcmp(Vals{5},'off'))
    En{6}  = 'off';
else % 'Frame-based'
    En{6}  = 'on';
end;

if ( strcmp(oldEnSampPerFrames, En{6}) == 0 ) 
    set_param(block,'MaskEnables',En);
end

% [EOF]
